//=============================================================================
// WeaponDevestator.
//=============================================================================
class WeaponDevestator extends PhotonWeapon;

var float	mpRecoilStrength;

simulated function RefreshScopeDisplay (DeusExPlayer Player, bool bInstant, bool bScopeOn)
{
	if ( bScopeOn && (Player != None) )
	{
		DeusExRootWindow(Player.RootWindow).scopeView.ActivateView(ScopeFOV,False,bInstant);
		DeusExRootWindow(Player.RootWindow).HUD.augDisplay.bVisionActive=True;
		DeusExRootWindow(Player.RootWindow).HUD.augDisplay.visionLevel=3;
		DeusExRootWindow(Player.RootWindow).HUD.augDisplay.visionLevelValue=28800.00;
		AmbientSound=None;
	}
	else
	{
		if (  !bScopeOn )
		{
			DeusExRootWindow(Player.RootWindow).scopeView.DeactivateView();
			DeusExRootWindow(Player.RootWindow).HUD.augDisplay.bVisionActive=False;
			AmbientSound=None;
		}
	}
}

//
// functions to change ammo types
//
function bool LoadAmmo(int ammoNum)
{
	local class<Ammo> newAmmoClass;
	local Ammo newAmmo;
	local Pawn P;

	if ((ammoNum < 0) || (ammoNum > 2))
		return False;

	P = Pawn(Owner);

	// sorry, only pawns can have weapons
	if (P == None)
		return False;

	newAmmoClass = AmmoNames[ammoNum];

	if (newAmmoClass != None)
	{
		if (newAmmoClass != AmmoName)
		{
			newAmmo = Ammo(P.FindInventoryType(newAmmoClass));
			if (newAmmo == None)
			{
				P.ClientMessage(Sprintf(msgOutOf, newAmmoClass.Default.ItemName));
				return False;
			}
			
			// if we don't have a projectile for this ammo type, then set instant hit
			if (ProjectileNames[ammoNum] == None)
			{
				bInstantHit = True;
				bAutomatic = Default.bAutomatic;
				ShotTime = Default.ShotTime;
				if ( Level.NetMode != NM_Standalone )
				{
					if (HasReloadMod())
						ReloadTime = mpReloadTime * (1.0+ModReloadTime);
					else
						ReloadTime = mpReloadTime;
				}
				else
				{
					if (HasReloadMod())
						ReloadTime = Default.ReloadTime * (1.0+ModReloadTime);
					else
						ReloadTime = Default.ReloadTime;
				}
				FireSound = Default.FireSound;
				ProjectileClass = None;
			}
			else
			{
			AmmoName = newAmmoClass;
			AmmoType = newAmmo;

				// otherwise, set us to fire projectiles
				bInstantHit = False;
				bAutomatic = Default.bAutomatic;
				ShotTime = Default.ShotTime;
				if (HasReloadMod())
					ReloadTime = 2.0 * (1.0+ModReloadTime);
				else
					ReloadTime = 2.0;
				FireSound = Default.FireSound;		// handled by the projectile
				ProjectileClass = ProjectileNames[ammoNum];
				ProjectileSpeed = ProjectileClass.Default.Speed;

				if ( AmmoOrangePhoton(newAmmo) != None )
                                	{
                                        ReloadCount = 1;
                                        ShotTime = 1.000000;
                                        bAutomatic = False;
                                        NumBarrels = Num_Quadruple;
                                        FireSound = Sound'DeusExSounds.Weapons.GEPGunFire';
                                        }
				if ( AmmoTealPhoton(newAmmo) != None )
                                        {
                                        ReloadCount = Default.ReloadCount;
                                        NumBarrels = Default.NumBarrels;
                                        bAutomatic = Default.bAutomatic;
                                        ShotTime = Default.ShotTime;
                                        FireSound = Default.FireSound;
                                        }
                                }
			AmmoName = newAmmoClass;
			AmmoType = newAmmo;

			// AlexB had a new sound for 20mm but there's no mechanism for playing alternate sounds per ammo type
			// Same for WP rocket
			if ( Ammo20mm(newAmmo) != None )
				FireSound=Sound'AssaultGunFire20mm';
			else if ( AmmoRocketWP(newAmmo) != None )
				FireSound=Sound'GEPGunFireWP';
			else if ( AmmoRocket(newAmmo) != None )
				FireSound=Sound'GEPGunFire';

			if ( Level.NetMode != NM_Standalone )
				SetClientAmmoParams( bInstantHit, bAutomatic, ShotTime, FireSound, ProjectileClass, ProjectileSpeed );

			// Notify the object belt of the new ammo
			if (DeusExPlayer(P) != None)
				DeusExPlayer(P).UpdateBeltText(Self);

			ReloadAmmo();

			P.ClientMessage(Sprintf(msgNowHas, ItemName, newAmmoClass.Default.ItemName));
			return True;
		}
		else
		{
			P.ClientMessage(Sprintf(MsgAlreadyHas, ItemName, newAmmoClass.Default.ItemName));
		}
	}
	return False;
}

//simulated function SwapMuzzleFlashTexture()
//{
//   	if ( !bHasMuzzleFlash )
//      		return;  
//
//	MultiSkins[2] = Texture'GreenLaserSpot';
//	SetTimer(0.1, False);
//}

defaultproperties
{
     NumBarrels=Num_Double
     LowAmmoWaterMark=30
     GoverningSkill=Class'DeusEx.SkillWeaponHeavy'
     Concealability=CONC_Visual
     bAutomatic=True
     ShotTime=0.200000
     reloadTime=2.000000
     HitDamage=37
     BaseAccuracy=0.550000
     bHasScope=True
     bCanHaveLaser=True
     bHasLaser=True
     AmmoNames(0)=Class'Markistan.AmmoTealPhoton'
     AmmoNames(1)=Class'Markistan.AmmoOrangePhoton'
     ProjectileNames(0)=Class'Markistan.TealPhotonBlast'
     ProjectileNames(1)=Class'Markistan.GhostShell'
     recoilStrength=0.500000
     MinWeaponAcc=0.200000
     mpReloadTime=2.000000
     mpHitDamage=37
     mpAccurateRange=2400
     mpMaxRange=2400
     mpReloadCount=50
     bCanHaveModRecoilStrength=True
     AmmoName=Class'Markistan.AmmoTealPhoton'
     ReloadCount=100
     PickupAmmoCount=300
     FireOffset=(X=-16.000000,Y=5.000000,Z=11.500000)
     ProjectileClass=Class'Markistan.TealPhotonBlast'
     shakemag=200.000000
     FireSound=Sound'Markistan.Weapons.PhotonMachineGunFire'
     AltFireSound=Sound'DeusExSounds.Weapons.AssaultGunReloadEnd'
     CockingSound=Sound'DeusExSounds.Weapons.AssaultGunReload'
     SelectSound=Sound'DeusExSounds.Weapons.AssaultGunSelect'
     InventoryGroup=180
     ItemName="Q-96 photon devestator"
     ItemArticle="an"
     PlayerViewOffset=(X=16.000000,Y=-5.000000,Z=-11.500000)
     PlayerViewMesh=LodMesh'DeusExItems.AssaultGun'
     PickupViewMesh=LodMesh'DeusExItems.AssaultGunPickup'
     ThirdPersonMesh=LodMesh'DeusExItems.AssaultGun3rd'
     LandSound=Sound'DeusExSounds.Generic.DropMediumWeapon'
     Icon=Texture'Markistan.Icons.BeltIconQ96'
     largeIcon=Texture'Markistan.Icons.InventoryIconQ96'
     largeIconWidth=192
     largeIconHeight=96
     invSlotsX=4
     invSlotsY=2
     Description="The future of assault rifles, the Q-96 weilds deadly teal photons, unbelievable accuracy, and an insane ammunition capacity. It's an assault rifle like no other, and if it wasn't unbeleivable enough, it has 2 barrels that it fires from and it shoots hellaciously fast with an attached orange photon 'ghost' shell that can float through thin geometry!"
     beltDescription="Q-96"
     Mesh=LodMesh'DeusExItems.AssaultGunPickup'
     CollisionRadius=15.000000
     CollisionHeight=1.100000
     Mass=42.000000
}
